package parser;

/**
 * Factory for Empty grammar terminals.
 */
public class EmptyFact extends ATVFactory {
    /**
     * Constructor for Empty grammar terminals.
     *
     * @param tkz tokenizer to use
     */
    public EmptyFact(ITokenizer tkz) {
        super(tkz);
    }

    /**
     * Make a visitor to parse an empty terminal.
     *
     * @return visitor to parse an empty terminal
     */
    private ITokVisitor makeEmptyVis() {
        return new ITokVisitor() {
            public Object defaultCase(AToken host, Object param) {
                putBackToken();
                System.err.println("Pushback");
                return Empty.Singleton;
            }
        };
    }

    /**
     * Make a token visitor to parse an Empty terminal.
     *
     * @return token visitor
     */
    public ITokVisitor makeVisitor() {
        return makeEmptyVis();
    }

    /**
     * Make a token visitor that delegates to the given visitor in a chain of responsibility
     *
     * @param successor visitor to serve as successor in the chain
     */
    public ITokVisitor makeChainedVisitor(ITokVisitor successor) {
        return makeEmptyVis();
    }
}

